﻿Imports Inventor

Module ThicknessMeasure
    Private WithEvents oInteraction As InteractionEvents
    Private WithEvents oSelectEvents As SelectEvents
    Private oGraphicsNode As GraphicsNode
    Private oLineGraphics As LineGraphics
    Private oCoords As GraphicsCoordinateSet
    Private oColor As GraphicsColorSet
    Private oTextGraphics As TextGraphics
    Private iIndex As Long
    Private bSelecting As Boolean


    Public Sub MeasureThickness()
        oInteraction = invApp.CommandManager.CreateInteractionEvents
        oInteraction.StatusBarText = "Specify measurement position."

        oSelectEvents = oInteraction.SelectEvents
        oSelectEvents.AddSelectionFilter(SelectionFilterEnum.kPartFaceFilter)
        oSelectEvents.SingleSelectEnabled = True

        iIndex = iIndex + 1
        oGraphicsNode = oInteraction.InteractionGraphics.PreviewClientGraphics.AddNode(iIndex)

        iIndex = iIndex + 1
        oCoords = oInteraction.InteractionGraphics.GraphicsDataSets.CreateCoordinateSet(iIndex)
        oCoords.Add(1, invApp.TransientGeometry.CreatePoint(0, 0, 0))
        oCoords.Add(2, invApp.TransientGeometry.CreatePoint(1, 0, 0))

        iIndex = iIndex + 1
        oColor = oInteraction.InteractionGraphics.GraphicsDataSets.CreateColorSet(iIndex)
        oColor.Add(4, 255, 255, 0)

        oLineGraphics = oGraphicsNode.AddLineGraphics
        oLineGraphics.BurnThrough = True
        oLineGraphics.ColorSet = oColor
        oLineGraphics.CoordinateSet = oCoords

        oTextGraphics = oGraphicsNode.AddTextGraphics
        oTextGraphics.BurnThrough = True
        oTextGraphics.Anchor = oCoords.Coordinate(1)
        oTextGraphics.Text = ""

        oInteraction.Start()

        bSelecting = True
        Do While bSelecting
            System.Windows.Forms.Application.DoEvents()
            System.Threading.Thread.CurrentThread.Join(0)
        Loop

        ' Clean up.
        oGraphicsNode.Delete()
        oGraphicsNode = Nothing
        oInteraction.Stop()
        oInteraction = Nothing
        invApp.ActiveView.Update()
    End Sub


    Private Sub oInteraction_OnTerminate() Handles oInteraction.OnTerminate
        bSelecting = False
    End Sub

    Private Sub oSelectEvents_OnPreSelect(ByRef PreSelectEntity As Object, ByRef DoHighlight As Boolean, ByRef MorePreSelectEntities As ObjectCollection, SelectionDevice As SelectionDeviceEnum, ModelPosition As Point, ViewPosition As Point2d, View As View) Handles oSelectEvents.OnPreSelect
        oGraphicsNode.Visible = True
    End Sub

    Private Sub oSelectEvents_OnPreSelectMouseMove(PreSelectEntity As Object, ModelPosition As Point, ViewPosition As Point2d, View As View) Handles oSelectEvents.OnPreSelectMouseMove
        Dim oFace As Face
        oFace = PreSelectEntity.Item(1)

        Dim oTG As TransientGeometry
        oTG = invApp.TransientGeometry

        ' Correct the model position so it actually on the face and the
        ' display facets.
        Dim adPoint(2) As Double
        adPoint(0) = ModelPosition.X
        adPoint(1) = ModelPosition.Y
        adPoint(2) = ModelPosition.Z
        Dim adGuessParams() As Double = {}
        Dim adMaxDeviations() As Double = {}
        Dim adParams(1) As Double
        Dim akSolutionNatures() As SolutionNatureEnum = {}
        oFace.Evaluator.GetParamAtPoint(adPoint, adGuessParams, adMaxDeviations, adParams, akSolutionNatures)
        oFace.Evaluator.GetPointAtParam(adParams, adPoint)
        ModelPosition = oTG.CreatePoint(adPoint(0), adPoint(1), adPoint(2))

        Dim dModelPosition(2) As Double
        dModelPosition(0) = ModelPosition.X
        dModelPosition(1) = ModelPosition.Y
        dModelPosition(2) = ModelPosition.Z
        Dim dGuessParams() As Double = {}
        Dim dMaxDeviations() As Double = {}
        Dim dParams() As Double = {}
        Dim SolutionNature() As SolutionNatureEnum = {}

        oFace.Evaluator.GetParamAtPoint(dModelPosition, dGuessParams, dMaxDeviations, dParams, SolutionNature)
        Dim dNormal(2) As Double
        oFace.Evaluator.GetNormal(dParams, dNormal)

        ' Create a Vector object with the normal information.  Reverse the
        ' direction of the vector so it's pointing inside the solid.
        Dim oNormalVec As UnitVector
        oNormalVec = oTG.CreateUnitVector(-dNormal(0), -dNormal(1), -dNormal(2))

        Dim oTempPoint As Point
        oTempPoint = oTG.CreatePoint(ModelPosition.X, ModelPosition.Y, ModelPosition.Z)
        oTempPoint.TranslateBy(oTG.CreateVector(oNormalVec.X * 0.001, oNormalVec.Y * 0.001, oNormalVec.Z * 0.001))

        ' Find the opposing face.
        Dim oFoundEnts As ObjectsEnumerator = Nothing
        Dim oLocationPoints As ObjectsEnumerator = Nothing
        oFace.Parent.FindUsingRay(oTempPoint, oNormalVec, 0.00001, oFoundEnts, oLocationPoints, False)

        Dim oOtherPoint As Point
        oOtherPoint = Nothing
        If oLocationPoints.Count > 0 Then
            ' Check to see if the first point is different than the input point.
            oTempPoint = oLocationPoints.Item(1)
            If oTempPoint.DistanceTo(ModelPosition) < 0.05 Then
                ' See if there's a second face and use it.
                If oFoundEnts.Count > 1 Then
                    oOtherPoint = oLocationPoints.Item(2)
                End If
            Else
                oOtherPoint = oLocationPoints.Item(1)
            End If
        End If

        If Not oOtherPoint Is Nothing Then
            Dim dCoords(5) As Double
            dCoords(0) = ModelPosition.X
            dCoords(1) = ModelPosition.Y
            dCoords(2) = ModelPosition.Z
            dCoords(3) = oOtherPoint.X
            dCoords(4) = oOtherPoint.Y
            dCoords(5) = oOtherPoint.Z
            oCoords.PutCoordinates(dCoords)

            Dim value As String = oInteraction.TargetDocument.UnitsOfMeasure.GetStringFromValue(ModelPosition.DistanceTo(oOtherPoint), Inventor.UnitsTypeEnum.kDefaultDisplayLengthUnits)
            Dim displayMsg As String = "Thickness: " & value
            oTextGraphics.Text = value
            oTextGraphics.Anchor = oCoords.Coordinate(1)
            oInteraction.StatusBarText = displayMsg
            invApp.ActiveView.Update()
        End If
    End Sub


    Private Sub oSelectEvents_OnStopPreSelect(ModelPosition As Point, ViewPosition As Point2d, View As View) Handles oSelectEvents.OnStopPreSelect
        oGraphicsNode.Visible = False
        invApp.ActiveView.Update()
        oInteraction.StatusBarText = ""
    End Sub
End Module
