﻿Imports Inventor

Module UtilityFunctions
    ' Returns the normal for the face at an arbitrary location. This is most useful
    ' for getting the normal from a planar face because it's the same anywhere on
    ' the plane.
    Public Function GetNormal(face As Inventor.Face) As Vector
        ' Get the surface evaluator from the face.
        Dim surfEval As SurfaceEvaluator = face.Evaluator

        Dim facePoint As Point = face.PointOnFace
        Dim pointAsArray() As Double = {facePoint.X, facePoint.Y, facePoint.Z}
        Dim normalCoords() As Double = {}
        surfEval.GetNormalAtPoint(pointAsArray, normalCoords)

        Return tg.CreateVector(normalCoords(0), normalCoords(1), normalCoords(2))
    End Function

    ' Determines if two values are within a specified tolerance or it uses
    ' the internal point tolerance as the default.
    Public Function WithinTol(ByVal Value1 As Double, ByVal Value2 As Double, Optional ByVal Tolerance As Double = 0) As Boolean
        If Tolerance = 0 Then
            Tolerance = tg.PointTolerance
        End If

        If Math.Abs(Value1 - Value2) < Tolerance Then
            Return True
        Else
            Return False
        End If
    End Function
End Module


Public Module Globals
    Public Const g_CurrentPath As String = "C:\Users\ekins\OneDrive\Documents\Presentations\AU 2018\GeometryAndBRep\Samples\"

    Private m_invApp As Inventor.Application = Nothing
    Private m_tg As TransientGeometry = Nothing

    Public ReadOnly Property tg As TransientGeometry
        Get
            If m_tg Is Nothing Then
                m_tg = m_invApp.TransientGeometry
            End If

            Return m_tg
        End Get
    End Property

    Public ReadOnly Property invApp As Inventor.Application
        Get
            If m_invApp Is Nothing Then
                Try
                    m_invApp = GetObject(, "Inventor.Application")
                Catch ex As Exception
                    MsgBox("Inventor must be running")
                    Return Nothing
                End Try
            End If

            Return m_invApp
        End Get
    End Property
End Module
