#Author - Brian Ekins (EkinsSolutions.com)
#Description - Cuts a selected body into slices and lays them out on a plane to 
#              allow the creation of tool paths to machine the individual slices.
#(C) Copyright 2018-2024 by Ekins Solutions, LLC.
# Permission to use, copy, modify, and distribute this software in any form for any 
# purpose and without fee is hereby granted, provided that the above copyright notice
# appears in all copies and that both that copyright notice and the limited warranty
# and restricted rights notice below appear in all supporting documentation.
    
# EKINS SOLUTIONS LLC PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. EKINS SOLUTIONS LLC
# SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.
# EKINS SOLUTIONS LLC DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE UNINTERRUPTED OR ERROR FREE.

import adsk.core, adsk.fusion, adsk.cam, traceback
from .Packages import NiftySlicer_Util

_app = adsk.core.Application.cast(None)
_ui = adsk.core.UserInterface.cast(None)


def run(context):
    try:
        global _app, _ui
        _app = adsk.core.Application.get()
        _ui  = _app.userInterface
        
        NiftySlicer_Util.initialize()
    except:
        if _ui:
            _ui.messageBox('Failed:\n{}'.format(traceback.format_exc()))


def stop(context):
    try:
        NiftySlicer_Util.destroy()
    except:
        _ui.messageBox('Failed:\n{}'.format(traceback.format_exc()))
