﻿Imports Inventor

Public Class Form1
    Private m_noteList As New Dictionary(Of String, String)

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Dim exePath As String
        exePath = System.Reflection.Assembly.GetExecutingAssembly.Location

        Dim notesFile = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(exePath), "Notes.xml")

        Dim xmlDoc As System.Xml.XmlDocument = New Xml.XmlDocument()
        xmlDoc.Load(notesFile)

        Dim xmlNoteList As Xml.XmlNodeList = xmlDoc.SelectNodes("Notes/Note")
        For Each noteNode As Xml.XmlNode In xmlNoteList
            Dim name As String = ""
            Dim text As String = ""

            For Each childNode As Xml.XmlNode In noteNode.ChildNodes
                If childNode.Name.ToUpper = "TITLE" Then
                    name = childNode.InnerText
                ElseIf childNode.Name.ToUpper = "FORMATTEDTEXT" Then
                    text = childNode.InnerText
                End If
            Next

            m_noteList.Add(name, text)
        Next

        For Each dictItem As KeyValuePair(Of String, String) In m_noteList
            chkListNotes.Items.Add(dictItem.Key, False)
        Next
    End Sub

    Private Sub btnCancel_Click(sender As Object, e As EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub


    Private Sub btnPlace_Click(sender As Object, e As EventArgs) Handles btnPlace.Click
        Dim noteText As String = ""
        Dim cnt As Integer = 0
        For Each checkedNote As String In chkListNotes.CheckedItems
            Dim noteValue As String = m_noteList.Item(checkedNote)

            If noteText = "" Then
                If chkAddNumbers.Checked Then
                    cnt += 1
                    noteText = cnt.ToString & ". " & noteValue
                Else
                    noteText = noteValue
                End If
            Else
                If chkAddNumbers.Checked Then
                    cnt += 1
                    noteText &= "<Br/>" & cnt.ToString & ". " & noteValue
                Else
                    noteText &= "<Br/>" & noteValue
                End If
            End If
        Next

        Dim invApp As Inventor.Application
        Dim drawDoc As DrawingDocument
        Try
            invApp = GetObject(, "Inventor.Application")
            drawDoc = invApp.ActiveDocument
        Catch ex As Exception
            MsgBox("Inventor must be running and drawing document active.")
            Return
        End Try

        Dim trans As Transaction = invApp.TransactionManager.StartTransaction(drawDoc, "Add Notes")
        Dim sht As Sheet = drawDoc.ActiveSheet
        Dim pstn As Point2d = invApp.TransientGeometry.CreatePoint2d(sht.Border.RangeBox.MinPoint.X + 0.5, sht.Border.RangeBox.MaxPoint.Y - 0.5)
        Dim note As GeneralNote = sht.DrawingNotes.GeneralNotes.AddFitted(pstn, noteText)
        note.HorizontalJustification = HorizontalTextAlignmentEnum.kAlignTextLeft
        note.VerticalJustification = VerticalTextAlignmentEnum.kAlignTextUpper
        trans.End()
    End Sub



End Class
