﻿Imports Inventor

Public Class Form1
    Private m_InvApp As Inventor.Application

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Try
            m_InvApp = GetObject(, "Inventor.Application")
        Catch ex As Exception
            MsgBox("Inventor must be running.")
            Me.Close()
        End Try

        If m_InvApp.ActiveDocumentType <> DocumentTypeEnum.kDrawingDocumentObject Then
            MsgBox("A drawing document must be active.")
            Me.Close()
        End If

        Me.Show()

        Dim keepSelecting = True
        Do
            Dim entity As Object = Nothing
            entity = m_InvApp.CommandManager.Pick(SelectionFilterEnum.kDrawingDefaultFilter, "Select drawing annotation")
            If IsNothing(entity) Then
                keepSelecting = False
            End If

            lstResults.Items.Clear()

            Try
                Dim intent = entity.intent
                lstResults.Items.Add("Intent")
                GetIntentInfo(intent)
            Catch ex As Exception
            End Try

            Try
                Dim intent = entity.IntentOne
                lstResults.Items.Add("Intent One")
                If Not IsNothing(intent) Then
                    GetIntentInfo(intent)
                End If
            Catch ex As Exception
            End Try

            Try
                Dim intent = entity.IntentTwo
                If Not IsNothing(intent) Then
                    lstResults.Items.Add("Intent Two")
                    GetIntentInfo(intent)
                End If
            Catch ex As Exception
            End Try

            Try
                Dim intent = entity.IntentThree
                If Not IsNothing(intent) Then
                    lstResults.Items.Add("Intent Three")
                    GetIntentInfo(intent)
                End If
            Catch ex As Exception
            End Try

            Try
                Dim leader As Leader = entity.Leader
                lstResults.Items.Add("Leader")
                Dim gotIntent As Boolean = False
                If leader.HasRootNode Then
                    If Not IsNothing(leader.RootNode.AttachedEntity) Then
                        GetIntentInfo(leader.RootNode.AttachedEntity)
                        gotIntent = True
                    End If
                End If

                If Not gotIntent Then
                    Dim node As LeaderNode = leader.AllNodes.Item(leader.AllNodes.Count)
                    If Not IsNothing(node.AttachedEntity) Then
                        GetIntentInfo(node.AttachedEntity)
                    End If
                End If
            Catch ex As Exception
            End Try
        Loop While keepSelecting

        Me.Close()
    End Sub

    Private Sub GetIntentInfo(geomIntent As GeometryIntent)
        Try
            Dim result As String = ""
            Dim attachedEnt As Object = geomIntent.Geometry

            If TypeOf attachedEnt Is DrawingCurve Then
                Dim drawCurve As DrawingCurve = attachedEnt
                lstResults.Items.Add("   Entity: " & TypeName(attachedEnt) & ", " & TypeName(drawCurve.ModelGeometry) & ", " & System.Enum.GetName(drawCurve.ProjectedCurveType.GetType, drawCurve.ProjectedCurveType))
            Else
                lstResults.Items.Add("   Entity: " & TypeName(attachedEnt))
            End If
            lstResults.Items.Add("   Intent Type: " & System.Enum.GetName(geomIntent.IntentType.GetType, geomIntent.IntentType))
            Select Case geomIntent.IntentType
                Case IntentTypeEnum.kPointIntent
                    lstResults.Items.Add("      Point Intent Type: " & System.Enum.GetName(geomIntent.Intent.GetType, geomIntent.Intent))
                Case IntentTypeEnum.kPointEnumIntent
                    Dim pointIntent As PointIntentEnum = geomIntent.Intent
                    lstResults.Items.Add("      Point Enum Intent Type: " & System.Enum.GetName(pointIntent.GetType, pointIntent))
                Case IntentTypeEnum.kGeometryIntent
                    lstResults.Items.Add("      Geometry Intent: " & TypeName(geomIntent.Intent))
                Case IntentTypeEnum.kNoPointIntent
                    lstResults.Items.Add("      No Point Intent")
                Case IntentTypeEnum.kParameterIntent
                    lstResults.Items.Add("      Parameter Intent: " & geomIntent.Intent.ToString)
                Case IntentTypeEnum.kPoint2dIntent
                    Dim pnt2d As Point2d = geomIntent.Intent
                    lstResults.Items.Add("      Point2d Intent:" & pnt2d.X & ", " & pnt2d.Y)
                Case IntentTypeEnum.kPointIntent
                    Dim pnt As Point = geomIntent.Intent
                    lstResults.Items.Add("      Point Intent:" & pnt.X & ", " & pnt.Y & ", " & pnt.Z)
                Case Else
                    lstResults.Items.Add("unknown")
            End Select
        Catch ex As Exception
        End Try
    End Sub
End Class
