﻿Imports Inventor

Public Class Form1
    Private invApp As Inventor.Application = Nothing
    Private WithEvents intEvents As InteractionEvents
    Private WithEvents mouseEvents As MouseEvents
    Private view As Inventor.View = Nothing
    Private lastPoint As Point2d = Nothing

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Try
            invApp = GetObject(, "Inventor.Application")
        Catch ex As Exception
            MsgBox("Inventor must be running.")
            Me.Close()
        End Try
    End Sub

    Private Sub intEvents_OnActivate() Handles intEvents.OnActivate
        mouseEvents = intEvents.MouseEvents
        mouseEvents.MouseMoveEnabled = True
    End Sub

    Private Sub intEvents_OnTerminate() Handles intEvents.OnTerminate
        mouseEvents = Nothing
    End Sub

    Private Sub mouseEvents_OnMouseDown(Button As MouseButtonEnum, ShiftKeys As ShiftStateEnum, ModelPosition As Point, ViewPosition As Point2d, View As View) Handles mouseEvents.OnMouseDown
        lastPoint = ViewPosition
        Debug.Print("Mouse Down")
    End Sub

    Private Sub mouseEvents_OnMouseMove(Button As MouseButtonEnum, ShiftKeys As ShiftStateEnum, ModelPosition As Point, ViewPosition As Point2d, View As View) Handles mouseEvents.OnMouseMove
        If Not lastPoint Is Nothing Then
            Debug.Print("Setting Camera")

            Dim cam As Camera = View.Camera
            cam.ComputeWithMouseInput(lastPoint, ViewPosition, 0, ViewOperationTypeEnum.kRotateViewOperation)
            cam.ApplyWithoutTransition()
            lastPoint = ViewPosition
        End If
    End Sub

    Private Sub mouseEvents_OnMouseUp(Button As MouseButtonEnum, ShiftKeys As ShiftStateEnum, ModelPosition As Point, ViewPosition As Point2d, View As View) Handles mouseEvents.OnMouseUp
        lastPoint = Nothing
    End Sub

    Private Sub btnRotate_Click(sender As Object, e As EventArgs) Handles btnRotate.Click
        intEvents = invApp.CommandManager.CreateInteractionEvents()
        intEvents.Start()
    End Sub

    Private Sub btnReset_Click(sender As Object, e As EventArgs) Handles btnReset.Click
        Dim cam As Camera = invApp.ActiveView.Camera
        cam.ViewOrientationType = ViewOrientationTypeEnum.kFrontViewOrientation
        cam.Fit()
        cam.Apply()
    End Sub

    Private Sub btnCancel_Click(sender As Object, e As EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub
End Class
