﻿Imports Inventor

Public Class frmEditTitleBlock
    Private m_dateControl As Windows.Forms.TextBox = Nothing
    Private m_invApp As Inventor.Application = Nothing
    Private m_drawDoc As DrawingDocument = Nothing

    Private Sub btnCancel_Click(sender As Object, e As EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub date_MouseClick(sender As Object, e As MouseEventArgs) Handles txtDrawnDate.MouseClick, txtApprovedDate.MouseClick, txtCheckedDate.MouseClick, txtDrawnDate.MouseClick, txtMFGDate.MouseClick, txtQADate.MouseClick
        calCalendar.Left = 85
        calCalendar.Top = 14
        calCalendar.Visible = True

        m_dateControl = sender

        If m_dateControl.Text = "" Then
            calCalendar.SelectionStart = Now
            calCalendar.SelectionEnd = Now
        Else
            Dim currentDate As Date = m_dateControl.Text
            calCalendar.SelectionStart = currentDate
            calCalendar.SelectionEnd = currentDate

        End If
    End Sub

    Private Sub calCalendar_DateSelected(sender As Object, e As DateRangeEventArgs) Handles calCalendar.DateSelected
        m_dateControl.Text = String.Format("{0:d}", calCalendar.SelectionStart)
        m_dateControl = Nothing
        calCalendar.Visible = False
    End Sub

    Private Sub Form1_MouseClick(sender As Object, e As MouseEventArgs) Handles Me.MouseClick, picTitleBlock.MouseClick
        If calCalendar.Visible Then
            calCalendar.Visible = False
        End If
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        ' Connect to Inventor.
        Try
            m_invApp = GetObject(, "Inventor.Application")
        Catch ex As Exception
            MsgBox("Inventor must be running.")
            Me.Close()
        End Try

        ' Check that the active document is a drawing.
        If m_invApp.ActiveDocumentType <> DocumentTypeEnum.kDrawingDocumentObject Then
            MsgBox("A drawing must be active.")
            Me.Close()
        End If
        m_drawDoc = m_invApp.ActiveDocument

        ' Populate the dialog with the current values.
        txtDrawn.Text = GetPropertyValue("Inventor Summary Information", "Author")
        txtTitle.Text = GetPropertyValue("Inventor Summary Information", "Title")
        txtRev.Text = GetPropertyValue("Inventor Summary Information", "Revision Number")

        txtChecked.Text = GetPropertyValue("Design Tracking Properties", "Checked By")
        txtMFG.Text = GetPropertyValue("Design Tracking Properties", "Mfg Approved By")
        txtApproved.Text = GetPropertyValue("Design Tracking Properties", "Engr Approved By")
        txtDrawingNo.Text = GetPropertyValue("Design Tracking Properties", "Part Number")

        txtQA.Text = GetPropertyValue("Inventor User Defined Properties", "QA")
        txtQADate.Text = GetPropertyValue("Inventor User Defined Properties", "QA Date")

        txtDrawnDate.Text = GetPropertyValue("Design Tracking Properties", "Creation Time")
        txtCheckedDate.Text = GetPropertyValue("Design Tracking Properties", "Date Checked")
        txtMFGDate.Text = GetPropertyValue("Design Tracking Properties", "Mfg Date Approved")
        txtApprovedDate.Text = GetPropertyValue("Design Tracking Properties", "Engr Date Approved")
    End Sub

    Private Function GetPropertyValue(PropertySetName As String, PropertyName As String) As String
        Try
            If PropertySetName = "Inventor User Defined Properties" Then
                Dim propSet As PropertySet = m_drawDoc.PropertySets.Item(PropertySetName)
                Dim prop As Inventor.Property = Nothing
                Try
                    prop = propSet.Item(PropertyName)
                    Return prop.Value.ToString()
                Catch ex As Exception
                    ' The property doesn't exist, so create it.
                    propSet.Add("", PropertyName)
                    Return ""
                End Try
            Else
                Dim propSet As PropertySet = m_drawDoc.PropertySets.Item(PropertySetName)
                Dim prop As Inventor.Property = propSet.Item(PropertyName)

                If TypeOf prop.Value Is Date Then
                    If prop.Value = CType("Jan. 1, 1601", Date) Then
                        Return ""
                    Else
                        Return String.Format("{0:d}", prop.Value)
                    End If
                Else
                    Return prop.Value
                End If
            End If
        Catch ex As Exception
            Return ""
        End Try
    End Function

    Private Sub SetPropertyValue(PropertySetName As String, PropertyName As String, Value As String)
        Dim propSet As PropertySet = m_drawDoc.PropertySets.Item(PropertySetName)
        Dim prop As Inventor.Property = propSet.Item(PropertyName)

        If TypeOf prop.Value Is Date Then
            If Value = "" Then
                prop.Value = CType("Jan. 1, 1601", Date)
            Else
                prop.Value = CType(Value, Date)
            End If
        Else
            prop.Value = Value
        End If
    End Sub

    Private Sub btnOK_Click(sender As Object, e As EventArgs) Handles btnOK.Click
        ' Save the current values.
        SetPropertyValue("Inventor Summary Information", "Author", txtDrawn.Text)
        SetPropertyValue("Inventor Summary Information", "Title", txtTitle.Text)
        SetPropertyValue("Inventor Summary Information", "Revision Number", txtRev.Text)

        SetPropertyValue("Design Tracking Properties", "Checked By", txtChecked.Text)
        SetPropertyValue("Design Tracking Properties", "Mfg Approved By", txtMFG.Text)
        SetPropertyValue("Design Tracking Properties", "Engr Approved By", txtApproved.Text)
        SetPropertyValue("Design Tracking Properties", "Part Number", txtDrawingNo.Text)

        SetPropertyValue("Inventor User Defined Properties", "QA", txtQA.Text)
        SetPropertyValue("Inventor User Defined Properties", "QA Date", txtQADate.Text)

        SetPropertyValue("Design Tracking Properties", "Creation Time", txtDrawnDate.Text)
        SetPropertyValue("Design Tracking Properties", "Date Checked", txtCheckedDate.Text)
        SetPropertyValue("Design Tracking Properties", "Mfg Date Approved", txtMFGDate.Text)
        SetPropertyValue("Design Tracking Properties", "Engr Date Approved", txtApprovedDate.Text)

        m_drawDoc.Update()
        Me.Close()
    End Sub
End Class
