﻿Imports Inventor

Public Class Form1
    Private Sub btnDraw_Click(sender As Object, e As EventArgs) Handles btnDraw.Click
        Dim invApp As Inventor.Application = Nothing
        Try
            invApp = GetObject(, "Inventor.Application")
        Catch ex As Exception
            MsgBox("Inventor must be running.")
            Me.Close()
        End Try

        ' Create a new drawing document using the default template.
        Dim oDrawDoc As DrawingDocument
        oDrawDoc = invApp.Documents.Add(DocumentTypeEnum.kDrawingDocumentObject, invApp.FileManager.GetTemplateFile(DocumentTypeEnum.kDrawingDocumentObject))

        ' Create a new sheet.
        Dim oSheet As Sheet
        oSheet = oDrawDoc.Sheets.Add(DrawingSheetSizeEnum.kCDrawingSheetSize, , "Sample Sheet")

        ' Add a border.
        Dim oBorder As Border
        oBorder = oSheet.AddDefaultBorder()

        ' Add a title block.
        Dim tbDef As TitleBlockDefinition
        tbDef = oDrawDoc.TitleBlockDefinitions.Item("ANSI - Large")
        Dim tb As TitleBlock
        tb = oSheet.AddTitleBlock(tbDef)

        ' Open the part to be inserted into the drawing.
        Dim partDoc As PartDocument
        partDoc = invApp.Documents.Open("C:\Users\ekins\OneDrive\Documents\Presentations\AU 2019\Examples\Models\CarbIntakePlate_Auto.ipt", False)

        Dim tg As TransientGeometry
        tg = invApp.TransientGeometry

        ' Get all the part edges.
        Dim partEdges(10) As Edge
        Dim i As Integer
        For i = 0 To 10
            Dim objs As ObjectCollection
            objs = partDoc.AttributeManager.FindObjects("Name", "Name", "Edge" & i)
            partEdges(i) = objs.Item(1)
        Next

        MsgBox("Create base and orthographic views.")

        ' Place the base front view.
        Dim frontView As DrawingView
        frontView = oSheet.DrawingViews.AddBaseView(partDoc, tg.CreatePoint2d(12, 15), 8, ViewOrientationTypeEnum.kFrontViewOrientation, DrawingViewStyleEnum.kHiddenLineDrawingViewStyle)

        ' Create the top, right and iso views.
        Dim topView As DrawingView
        topView = oSheet.DrawingViews.AddProjectedView(frontView, tg.CreatePoint2d(12, 30), DrawingViewStyleEnum.kFromBaseDrawingViewStyle)

        Dim isoView As DrawingView
        isoView = oSheet.DrawingViews.AddProjectedView(frontView, tg.CreatePoint2d(44, 33), DrawingViewStyleEnum.kHiddenLineRemovedDrawingViewStyle)

        MsgBox("Create section view.")

        ' Create a front section view by defining a section line in the front view.
        Dim sectionSketch As DrawingSketch
        sectionSketch = frontView.Sketches.Add

        sectionSketch.Edit()

        ' Get the associated drawingcurve.
        Dim drawViewCurves As DrawingCurvesEnumerator
        drawViewCurves = frontView.DrawingCurves(partEdges(10))
        Dim oCurve10 As DrawingCurve
        oCurve10 = drawViewCurves.Item(1)

        Dim oCircularEntity As SketchEntity
        oCircularEntity = sectionSketch.AddByProjectingEntity(oCurve10)

        ' Draw the section line.
        Dim sectionLine As SketchLine
        sectionLine = sectionSketch.SketchLines.AddByTwoPoints(tg.CreatePoint2d(0, 0.8), tg.CreatePoint2d(0, -0.8))

        ' Create a constraint to the projected circle center point and the line.
        Call sectionSketch.GeometricConstraints.AddCoincident(sectionLine, oCircularEntity.CenterSketchPoint)

        sectionSketch.ExitEdit()

        ' Create the section view.
        Dim oSectionView As SectionDrawingView
        oSectionView = oSheet.DrawingViews.AddSectionView(frontView, sectionSketch, tg.CreatePoint2d(28, 10), DrawingViewStyleEnum.kHiddenLineRemovedDrawingViewStyle, , False)

        MsgBox("Create detail view.")

        ' Create the detail view.
        Dim oDetailView As DetailDrawingView
        oDetailView = oSheet.DrawingViews.AddDetailView(oSectionView, tg.CreatePoint2d(42, 17), DrawingViewStyleEnum.kFromBaseDrawingViewStyle, True, tg.CreatePoint2d(25, 17.5), 2, , 16, , "A")

        MsgBox("Create dimensions to the curves in the views.")

        ' Get the equivalent drawing curves in the front view.
        drawViewCurves = frontView.DrawingCurves(partEdges(0))
        Dim frontCurve0 As DrawingCurve
        frontCurve0 = drawViewCurves.Item(1)

        drawViewCurves = frontView.DrawingCurves(partEdges(1))
        Dim frontCurve1 As DrawingCurve
        frontCurve1 = drawViewCurves.Item(1)

        ' Get drawing curves in the top view.
        drawViewCurves = frontView.DrawingCurves(partEdges(2))
        Dim frontCurve2 As DrawingCurve
        frontCurve2 = drawViewCurves.Item(1)

        drawViewCurves = frontView.DrawingCurves(partEdges(3))
        Dim frontCurve3 As DrawingCurve
        frontCurve3 = drawViewCurves.Item(1)

        drawViewCurves = frontView.DrawingCurves(partEdges(4))
        Dim frontCurve4 As DrawingCurve
        frontCurve4 = drawViewCurves.Item(1)

        drawViewCurves = frontView.DrawingCurves(partEdges(5))
        Dim frontCurve5 As DrawingCurve
        frontCurve5 = drawViewCurves.Item(1)

        drawViewCurves = frontView.DrawingCurves(partEdges(10))
        Dim frontCurve10 As DrawingCurve
        frontCurve10 = drawViewCurves.Item(1)

        drawViewCurves = topView.DrawingCurves(partEdges(0))
        Dim topCurve0 As DrawingCurve
        topCurve0 = drawViewCurves.Item(1)

        drawViewCurves = topView.DrawingCurves(partEdges(6))
        Dim topCurve6 As DrawingCurve
        topCurve6 = drawViewCurves.Item(1)

        drawViewCurves = topView.DrawingCurves(partEdges(8))
        Dim topCurve8 As DrawingCurve
        topCurve8 = drawViewCurves.Item(1)

        ' Create dimensions to the front view.
        Dim oGeneralDims As GeneralDimensions
        oGeneralDims = oSheet.DrawingDimensions.GeneralDimensions
        Dim oDim As GeneralDimension
        oDim = oGeneralDims.AddLinear(tg.CreatePoint2d(19, 15), oSheet.CreateGeometryIntent(frontCurve1), oSheet.CreateGeometryIntent(frontCurve2), DimensionTypeEnum.kVerticalDimensionType)
        oDim = oGeneralDims.AddLinear(tg.CreatePoint2d(12, 7), oSheet.CreateGeometryIntent(frontCurve3), oSheet.CreateGeometryIntent(frontCurve4), DimensionTypeEnum.kHorizontalDimensionType)
        oDim = oGeneralDims.AddRadius(tg.CreatePoint2d(19, 22), oSheet.CreateGeometryIntent(frontCurve0))
        oDim = oGeneralDims.AddDiameter(tg.CreatePoint2d(5, 9), oSheet.CreateGeometryIntent(frontCurve5))

        ' Create dimensions to the top view.
        oDim = oGeneralDims.AddLinear(tg.CreatePoint2d(19, 32.5), oSheet.CreateGeometryIntent(topCurve0, PointIntentEnum.kStartPointIntent), oSheet.CreateGeometryIntent(topCurve8, PointIntentEnum.kStartPointIntent), DimensionTypeEnum.kVerticalDimensionType)
        oDim = oGeneralDims.AddLinear(tg.CreatePoint2d(19, 30), oSheet.CreateGeometryIntent(topCurve0, PointIntentEnum.kStartPointIntent), oSheet.CreateGeometryIntent(topCurve6), DimensionTypeEnum.kVerticalDimensionType)
        oDim = oGeneralDims.AddLinear(tg.CreatePoint2d(12, 25), oSheet.CreateGeometryIntent(topCurve6), , DimensionTypeEnum.kHorizontalDimensionType)

        MsgBox("Create a text box with a leader.")

        ' Place a text box with a leader.
        drawViewCurves = oDetailView.DrawingCurves(partEdges(9))
        Dim detailCurve As DrawingCurve
        detailCurve = drawViewCurves.Item(1)

        Dim objColl As ObjectCollection
        objColl = invApp.TransientObjects.CreateObjectCollection
        Call objColl.Add(tg.CreatePoint2d(38, 21))
        Call objColl.Add(oSheet.CreateGeometryIntent(detailCurve, 0.6))
        Dim leaderNote As LeaderNote
        leaderNote = oSheet.DrawingNotes.LeaderNotes.Add(objColl, "Text with a leader")
    End Sub

    Private Sub btnCancel_Click(sender As Object, e As EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub
End Class
