﻿Imports Inventor

Public Class Form1
    ' Declare the event objects
    Private WithEvents interactEvents As InteractionEvents
    Private WithEvents selEvents As SelectEvents
    Private activeDoc As Document
    Private otherDoc As Document

    Dim invApp As Inventor.Application = Nothing


    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Try
            invApp = GetObject(, "Inventor.Application")
        Catch ex As Exception
            MsgBox("Inventor must be running")
            Me.Close()
        End Try

        Start()
    End Sub

    Public Sub Start()
        ' Create an InteractionEvents object.
        interactEvents = invApp.CommandManager.CreateInteractionEvents

        ' Ensure interaction is enabled.
        interactEvents.InteractionDisabled = False

        ' Set a reference to the select events.
        selEvents = interactEvents.SelectEvents

        activeDoc = invApp.ActiveDocument

        ' Set the filter
        If activeDoc.DocumentType = DocumentTypeEnum.kDrawingDocumentObject Then
            selEvents.AddSelectionFilter(SelectionFilterEnum.kDrawingCurveSegmentFilter)
            otherDoc = activeDoc.ReferencedDocuments.Item(1)
        Else
            selEvents.AddSelectionFilter(SelectionFilterEnum.kPartFaceFilter)
            selEvents.AddSelectionFilter(SelectionFilterEnum.kPartEdgeFilter)
            otherDoc = activeDoc.ReferencingDocuments.Item(1)
        End If

        If activeDoc.DocumentType = DocumentTypeEnum.kDrawingDocumentObject Then
            Dim modelType As String
            If otherDoc.DocumentType = DocumentTypeEnum.kPartDocumentObject Then
                modelType = "Part"
            Else
                modelType = "Assembly"
            End If

            lblStatus1.Text = "Move over curves in drawing."
            lblStatus2.Text = "View associated edges/faces in " & modelType
        Else
            Dim modelType As String
            If otherDoc.DocumentType = DocumentTypeEnum.kPartDocumentObject Then
                modelType = "Part"
            Else
                modelType = "Assembly"
            End If

            lblStatus1.Text = "Move over faces and edges in " & modelType
            lblStatus2.Text = "View associated drawing curves in drawing."
        End If

        ' Start the InteractionEvents object.
        interactEvents.Start()
    End Sub

    Private Sub selEvents_OnPreSelect(ByRef PreSelectEntity As Object, ByRef DoHighlight As Boolean, ByRef MorePreSelectEntities As ObjectCollection, SelectionDevice As SelectionDeviceEnum, ModelPosition As Point, ViewPosition As Point2d, View As View) Handles selEvents.OnPreSelect
        otherDoc.SelectSet.Clear()

        If activeDoc.DocumentType = DocumentTypeEnum.kDrawingDocumentObject Then
            Dim modelEntity As Object
            modelEntity = PreSelectEntity.Parent.ModelGeometry

            If Not modelEntity Is Nothing Then
                On Error Resume Next
                otherDoc.SelectSet.Select(modelEntity)
                On Error GoTo 0
            End If
        Else
            Dim drawView As DrawingView
            For Each drawView In otherDoc.ActiveSheet.DrawingViews
                Dim drawCurves As DrawingCurvesEnumerator
                drawCurves = drawView.DrawingCurves(PreSelectEntity)

                If Not drawCurves Is Nothing Then
                    If drawCurves.Count > 0 Then

                        Dim drawCurve As DrawingCurve
                        For Each drawCurve In drawCurves
                            Dim curveSegment As DrawingCurveSegment
                            For Each curveSegment In drawCurve.Segments
                                otherDoc.SelectSet.Select(curveSegment)
                            Next
                        Next
                    End If
                Else
                    If TypeOf PreSelectEntity Is Edge Then
                        Dim modelEdge As Edge
                        modelEdge = PreSelectEntity

                        Dim params(1) As Double
                        params(0) = 0.25
                        params(1) = 0.75

                        Dim points(5) As Double

                        Call modelEdge.Evaluator.GetPointAtParam(params, points)

                        Dim modelPoint1 As Point
                        modelPoint1 = invApp.TransientGeometry.CreatePoint(points(0), points(1), points(2))

                        Dim sheetPoint1 As Point2d
                        sheetPoint1 = drawView.ModelToSheetSpace(modelPoint1)

                        Dim modelPoint2 As Point
                        modelPoint2 = invApp.TransientGeometry.CreatePoint(points(3), points(4), points(5))

                        Dim sheetPoint2 As Point2d
                        sheetPoint2 = drawView.ModelToSheetSpace(modelPoint2)

                        If Not sheetPoint1.IsEqualTo(sheetPoint2) Then
                            otherDoc.Activate()
                            Dim curves1 As ObjectsEnumerator
                            curves1 = drawView.Parent.FindUsingPoint(sheetPoint1)

                            Dim curves2 As ObjectsEnumerator
                            curves2 = drawView.Parent.FindUsingPoint(sheetPoint2)
                            activeDoc.Activate()

                            Dim curve1 As Object
                            Dim curve2 As Object
                            For Each curve1 In curves1
                                For Each curve2 In curves2
                                    If curve1 Is curve2 Then
                                        otherDoc.SelectSet.Select(curve1)
                                    End If
                                Next
                            Next
                        End If
                    End If
                End If
            Next
        End If
    End Sub


    Private Sub selEvents_OnStopPreSelect(ModelPosition As Point, ViewPosition As Point2d, View As View) Handles selEvents.OnStopPreSelect
        otherDoc.SelectSet.Clear()
    End Sub

    Private Sub btnCancel_Click(sender As Object, e As EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub
End Class
