#Author-Brian Ekins
#Description-Add-In that creates circular cuts in interior corners of a solid. This is referred to as a "dogbone". Because a circular bit can't cut sharp internal corners, the dogbone removes additional material to clear out the full internal corner.
# Copyright 2018-2024 Ekins Solutions, LLC

import adsk.core, traceback

# Variables used to keep class instances in scope.
_createAndEditDogboneCommand = None
_updateDogboneCommand = None
_deleteDogboneCommand = None
_roundEdgesCommand = None

_app = adsk.core.Application.get()
_ui = adsk.core.UserInterface.cast(_app.userInterface)

try:
    from .Packages.Settings import Settings
    Settings.init()
    from .Packages.NiftyDogboneUtil import NiftyDogboneUtil as dogbone   
    from .Packages.NiftyCore.NiftyCore import FormattedTraceback as formattedTraceback
    from .Packages.NiftyExtra import NiftyExtra as extra
except:
    if Settings.logFile:
        Settings.logFile.write('NiftyDogbone: Unexpected error while importing packages.\n')
        Settings.logFile.write('{}\n'.format(traceback.format_exc()))
        Settings.logFile.flush()
        Settings.logFile.close()

        if _ui:
            message = ('An unexpected error occurred while importing packages in the Nifty Dogbone add-in.<br><br>' +
                    'An error log is available in:<br>"' +
                    Settings.logFile.name + 
                    '"<br><br>If the problem continues, please notify <a href="https://EkinsSolutions.com/Contact">Ekins Solutions</a>.')
            _ui.messageBox(message, 'Nifty Dogbone', adsk.core.MessageBoxButtonTypes.OKButtonType, adsk.core.MessageBoxIconTypes.CriticalIconType)
    else:
        if _ui:
            _ui.messageBox('Unexpected error loading Nifty Dogbone.\n\n{}\n'.format(traceback.format_exc()))


def run(context):
    try:
        global _createAndEditDogboneCommand
        _createAndEditDogboneCommand = dogbone.CreateAndEditDogBoneCommand(context)
        
        global _updateDogboneCommand
        _updateDogboneCommand = dogbone.UpdateDogBoneCommand()        

        global _deleteDogboneCommand
        _deleteDogboneCommand = dogbone.DeleteDogBoneCommand()   

        global _roundEdgesCommand
        _roundEdgesCommand = extra.NiftyCornersCommand(context)     
    except:
        if Settings.logFile:
            Settings.logFile.write('NiftyDogbone.run: Unexpected error while creating command classes.\n')
            Settings.logFile.write('{}\n'.format(formattedTraceback(traceback)))
            Settings.logFile.flush()
            Settings.logFile.close()
    
        if _ui:
            message = ('An unexpected error occurred while loading the Nifty Dogbone add-in.<br><br>' +
                      'An error log is available in:<br>"' +
                      Settings.logFile.name + 
                      '"<br><br>If the problem continues, please notify <a href="https://EkinsSolutions.com/Contact">Ekins Solutions</a>.')
            _ui.messageBox(message, 'Nifty Dogbone', adsk.core.MessageBoxButtonTypes.OKButtonType, adsk.core.MessageBoxIconTypes.CriticalIconType)


def stop(context):
    try:
        global _createAndEditDogboneCommand
        _createAndEditDogboneCommand = None
        
        global _deleteDogboneCommand
        _deleteDogboneCommand = None

        global _updateDogboneCommand
        _updateDogboneCommand = None

        global _roundEdgesCommand
        _roundEdgesCommand = None
    except:
        if Settings.logFile:
            Settings.logFile.write('NiftyDogbone.run: Unexpected error while creating command classes.\n')
            Settings.logFile.write('{}\n'.format(formattedTraceback(traceback.format_exc())))
            Settings.logFile.flush()
            Settings.logFile.close()
    
        if _ui:
            message = ('An unexpected error occurred while unloading the Nifty Dogbone add-in.<br><br>' +
                      'An error log is available in:<br>"' +
                      Settings.logFile.name + 
                      '"<br><br>If the problem continues, please notify <a href="https://EkinsSolutions.com/Contact">Ekins Solutions</a>.')
            _ui.messageBox(message, 'Nifty Dogbone', adsk.core.MessageBoxButtonTypes.OKButtonType, adsk.core.MessageBoxIconTypes.CriticalIconType)